<?php

namespace Ignite\Core\Http\Controllers\Api;

use Ignite\Core\Entities\Participant;
use Ignite\Core\Http\Controllers\Controller;
use Illuminate\Http\Request;

class DataController extends Controller
{
    /**
     * Data for participants.
     *
     * @param Request $request
     *
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function participants(Request $request)
    {
        $search = $request->get('search', '');
        $currentPage = $request->get('page', 1);
        $identifier = config('core.transaction.resource.identifier', 'email');

        return Participant::query()
            ->where($identifier, 'like', "%{$search}%")
            ->orWhere('first', 'like', "%{$search}%")
            ->orWhere('last', 'like', "%{$search}%")
            ->paginate(10, ['user_id', $identifier, 'first', 'last'], 'page', $currentPage);
    }

    /**
     * Data for single participant.
     *
     * @param $userId
     * @param Request $request
     *
     * @return \Illuminate\Database\Eloquent\Model|Participant
     */
    public function participant($userId, Request $request)
    {
        $identifier = config('core.transaction.resource.identifier', 'email');

        return Participant::query()
            ->where('user_id', $userId)
            ->first(['user_id', $identifier, 'first', 'last']);
    }
}
