<?php

namespace Ignite\Core\Helpers;

use Carbon\Carbon;

class Date
{
    /**
     * @var Carbon|string|int
     */
    private $value;

    /**
     * DateTime constructor.
     *
     * @param Carbon|string|int $value
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * Reformat a Date with a default value
     *
     * @param  string $format
     * @param  string $default
     * @return false|string
     */
    public function format($format = 'Y-m-d', $default = '')
    {
        $date = preg_replace('/\s([0-9]+){2}\:([0-9]+){2}\:([0-9]+){2}$/', '', $this->value);

        if (empty(trim($date))) {
            return $default;
        }

        try {
            $date = Carbon::parse($date);
        } catch (\Exception $e) {
            return $default;
        }

        return $date->format($format);
    }
}
