<?php

namespace Ignite\Core\Exceptions;

use Exception;

class InvalidPasswordException extends Exception
{
    /**
     * Throw an exception when the participant provides a new password matching their old password.
     *
     * @return static
     */
    public static function reusedPassword()
    {
        return new static('The new password cannot be the same as your previous password.');
    }

    /**
     * Throw an exception when the participant provides an incorrect previous password.
     *
     * @return static
     */
    public static function incorrectPreviousPassword()
    {
        return new static('Old password did not match our records.');
    }
}
