<?php

namespace Ignite\Core\Events\Menus;

use Ignite\Core\Models\Menu\ActionMenu;

class ActionMenuPreCompile
{
    /**
     * @var ActionMenu
     */
    private $manager;

    /**
     * @var array
     */
    private $context;

    /**
     * ActionMenuPreCompile constructor.
     *
     * @param ActionMenu $manager
     * @param array $context
     */
    public function __construct(ActionMenu $manager, array $context)
    {
        $this->manager = $manager;
        $this->context = $context;
    }

    /**
     * The menu object.
     *
     * @return ActionMenu
     */
    public function getManager()
    {
        return $this->manager;
    }

    /**
     * The context array.
     *
     * @return array
     */
    public function getContext()
    {
        return $this->context;
    }
}
