<?php

namespace Ignite\Core\Events;

use Ignite\Core\Entities\User;
use Illuminate\Queue\SerializesModels;

class ImpersonationStarted
{
    use SerializesModels;

    /**
     * @var User
     */
    public $impersonator;

    /**
     * @var User
     */
    public $impersonated;

    /**
     * Create a new event instance.
     *
     * @param User $impersonator
     * @param $impersonated
     */
    public function __construct($impersonator, $impersonated)
    {
        $this->impersonator = $impersonator;
        $this->impersonated = $impersonated;
    }
}
