<?php

namespace Ignite\Core\Entities;

/**
 * Class Login
 *
 * @property int $id
 * @property int $user_id
 * @property string $session_id
 * @property string|null $ip_address
 * @property string|null $browser_name
 * @property string|null $browser_version
 * @property string|null $platform_name
 * @property string|null $platform_version
 * @property string|null $device
 * @property \Illuminate\Support\Carbon $created_at
 * @property-read \Ignite\Core\Entities\User $user
 * @method static \Illuminate\Database\Eloquent\Builder|Login newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Login newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Login query()
 * @method static \Illuminate\Database\Eloquent\Builder|Login whereBrowserName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Login whereBrowserVersion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Login whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Login whereDevice($value)
 * @method static Builder|Base whereHasPermission(string $permission, ?\Ignite\Core\Entities\User $user = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Login whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Login whereIpAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Login wherePlatformName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Login wherePlatformVersion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Login whereSessionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Login whereUserId($value)
 * @mixin \Eloquent
 */
class Login extends Base
{
    /**
     * The table name.
     *
     * @var string
     */
    protected $table = 'core_logins';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'datetime',
    ];

    /**
     * The relationship to the User model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
