<?php

namespace Ignite\Core\Database\Seeders;

use Ignite\Core\Entities\Permission;

class PermissionTableSeeder extends AbstractSeeder
{
    /**
     * The name of the data file.
     *
     * @var string
     */
    protected $file = 'core_permission.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        app('authorization')->forgetCachedPermissions();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath($this->file)
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                Permission::updateOrCreate(['key' => $source['key']], $source);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
