<?php

namespace Ignite\Core\Database\Seeders;

use Ignite\Core\Entities\Block;

class BlockTableSeeder extends AbstractSeeder
{
    /**
     * The name of the data file.
     *
     * @var string
     */
    protected $file = 'core_block.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath($this->file)
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                Block::updateOrCreate(['code' => $source['code']], $source);
            } catch (\Exception $e) {
                //echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
