@extends('Core::layouts.main')

@section('meta_title', 'Permissions Security Management')
@section('page_heading', 'Permissions')
@section('page_breadcrumb', 'Permissions')

@section('breadcrumb')
    @parent
    <li><a href="#">Security</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.security.permissions.index') }}">Permissions Management</a></small>
    </h1>
@endsection

@section('page_content')
    <div class="row">
        {!! form_start($form) !!}
            <div class="col-sm-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Create Permission</h3>
                    </div>
                    <div class="box-body bg-gray-light">
                        {!! form_until($form, 'status') !!}
                    </div>
                    <div class="box-footer">
                        <div class="form-buttons clearfix">
                            {!! form_row($form->submit) !!}
                        </div>
                    </div>
                </div>
            </div>
        {!! form_end($form) !!}
    </div>
@endsection
