@extends('Core::layouts.import')

@section('page_heading', 'Overview')
@section('page_breadcrumb', 'Overview')

@section('page_content')
    <div class="row">
        @can('core.import.create')
            <div class="col-md-3">
                @include('Core::admin.import.partials.form')
            </div>
        @endcan
        @can('core.import.browse')
            <div class="col-md-9">
                <div class="box box-primary">
                    <div class="box-body">
                        {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                    </div>
                </div>
            </div>
        @endcan
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            @can('core.import.delete')
            $.deleteEntry({
                confirmation: 'Are you sure you want to delete this import',
                request: { method: 'DELETE', type: 'json' },
                data: {
                    _token: "{{ csrf_token() }}"
                },
                onSuccess: function(button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function() {
                            $(this).remove();
                            $dataTable.DataTable().ajax.reload();
                        });
                }
            });
            @endcan
        });
    </script>
@endsection
