@extends('Core::layouts.cms')

@section('page_heading', 'Blocks')
@section('page_breadcrumb', 'Blocks')

@section('tab_content')
    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
    <form id="blocks-delete-form" action="{{ route('admin.blocks.destroyMany') }}" method="post">
        {{ csrf_field() }}
        {{ method_field('DELETE') }}
        <input type="hidden" name="ids" value="" id="blocks-delete-field" />
    </form>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function () {
            var $dataTable = $('#dataTableBuilder');

            var buttons = [];
            @can('core.cms.blocks.create')
            buttons.push({
                text: '<span class="fa-solid fa-plus text-success"></span> <span class="text-success">Create</span>',
                action: function (e, dt, node, conf) {
                    e.preventDefault();
                    window.location.href = '{{ route('admin.blocks.create') }}'
                }
            });
            @endcan
            @can('core.cms.blocks.delete.many')
            buttons.push({
                enabled: false,
                text: '<span class="fa-solid fa-trash text-danger"></span> <span class="text-danger">Delete</span>',
                action: function (e, dt, node, conf) {
                    var selected = dt.column(0).checkboxes.selected();
                    var message = 'You are about to permanently delete ' + selected.length + ' record(s). Are you sure you wish to proceed?';
                    if (confirm(message)) {
                        $('#blocks-delete-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                        $('#blocks-delete-form').submit();
                    }
                }
            });
            @endcan
            $dataTable.customButtons({buttons: buttons});

            @can('core.cms.blocks.delete')
            $.deleteEntry({
                data: function (button) {
                    return {
                        _token: "{{ csrf_token() }}",
                        id: button.attr('href').split('/').pop()
                    }
                },
                onSuccess: function (button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function () {
                            $(this).remove();
                            $dataTable.DataTable().ajax.reload();
                        });
                }
            });
            @endcan
        });
    </script>
@endsection
