(function (factory) {
    'use strict';

    if (typeof define === 'function' && define.amd) {
        define(['jquery'], factory);
    } else if (typeof module === 'object' && module.exports) {
        module.exports = factory(require('jquery'));
    } else {
        factory(window.jQuery);
    }
}
(function ($) {
    'use strict';

    $.extend(true, $.summernote.lang, {
        'en-US': {
            mediaManager: {
                tooltip: 'Browse Media'
            }
        }
    });

    $.extend($.summernote.options, {
        mediaManager: {
            icon: '<i class="fa-solid fa-server" style="line-height: 19px; position: relative; top: 2px;"></i>'
        },
        keyMap: {
            mac: $.extend($.summernote.options.keyMap.mac, {
                'CMD+SHIFT+I': 'mediaManager.show'
            }),
            pc: $.extend($.summernote.options.keyMap.pc, {
                'CTRL+SHIFT+I': 'mediaManager.show'
            })
        }
    });

    $.extend($.summernote.plugins, {
        'mediaManager': function (context) {
            var self = this;
            var ui = $.summernote.ui,
                options = context.options,
                lang = options.langInfo;

            context.memo('button.mediaManager', function () {
                return ui.button({
                    contents: options.mediaManager.icon,
                    container: false,
                    tooltip: lang.mediaManager.tooltip,
                    codeviewKeepButton: true,
                    click: function () {
                        context.invoke('mediaManager.show');
                    }
                }).render();
            });

            this.initialize = function () {
                // Nothing to initialize since the modal is a bootstrap modal with the contents pre-populated
                // using Blade and AlpineJS for dynamic behavior.
                // @see {MODULE}/resources/views/admin/cms/partials/list/files.blade.php
            };

            this.show = function () {
                $('#media-modal').modal('show');
            };
        }
    });
}));