<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBlockTable extends Migration
{
    /** @var string */
    protected $pageTable = 'core_block';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->pageTable, function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 255);
            $table->string('code', 255)->unique();
            $table->string('locale', 5)->nullable()->default('en_US');
            $table->text('content');
            $table->enum('status', ['active', 'inactive']);
            $table->timestamps();
            $table->timestamp('published_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->pageTable);
    }
}
