<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCoreNoteTable extends Migration
{
    protected $tableName = 'core_note';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->string('table_name', 100);
            $table->integer('table_primary_id');
            $table->integer('by_user_id');
            $table->integer('login_user_id');
            $table->text('message');
            $table->timestamps();
            $table->index('id');
            $table->index('by_user_id');
            $table->index('login_user_id');
            $table->index(['table_name', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
