<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCoreGroupPermissionTable extends Migration
{
    protected $tableName = 'core_group_permission';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('group_id');
            $table->unsignedInteger('permission_id');
            $table->timestamps();
            $table->foreign('group_id')->references('id')->on('core_group')->onDelete('cascade');
            $table->foreign('permission_id')->references('id')->on('core_permission')->onDelete('cascade');
            $table->unique(['group_id', 'permission_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
