<?php

namespace Ignite\Core\Tests\Support\Exports;

use Illuminate\Foundation\Testing\WithFaker;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SimpleExport implements FromArray, WithHeadings
{
    use Exportable;
    use WithFaker;

    public function array(): array
    {
        $this->setUpFaker();

        return [
            [
                $this->faker->firstName(),
                $this->faker->lastName(),
                $this->faker->email(),
                $this->faker->phoneNumber(),
            ],
            [
                $this->faker->firstName(),
                $this->faker->lastName(),
                $this->faker->email(),
                $this->faker->phoneNumber(),
            ],
        ];
    }

    public function headings(): array
    {
        return [
            'first',
            'last',
            'email',
            'phone',
        ];
    }
}
