<?php

namespace Ignite\Core\Audit;

use OwenIt\Auditing\Contracts\Audit as AuditContract;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Contracts\AuditDriver;
use OwenIt\Auditing\Drivers\Database;
use OwenIt\Auditing\Models\Audit as AuditModel;

class GenericDriver extends Database implements AuditDriver
{
    /**
     * @inheritDoc
     */
    public function audit(Auditable $model): AuditContract
    {
        $class = config('audit.implementation', AuditModel::class);
        $audit = $model->toAudit();
        $audit['context_type'] = get_class($model);
        $audit['context_id']   = $model->getKey();

        return $class::create($audit);
    }
}
