@extends('Core::layouts.report')

@section('page_heading',  $report->getName() . ' Report')
@section('page_breadcrumb', $report->getName() . ' Report')

@php
    $filterFields = isset($filters[$report->class]) ? $filters[$report->class] : [];
    $filterData = session()->get(md5($report->class), []);
    $filterDataValues = array_filter(array_map(function ($set) {
        if (! is_array($set) || empty($set) || ! array_key_exists('value', $set)) {
            return null;
        }
        return $set['value'] ?? null;
     }, $filterData));
@endphp

@section('page_content')
    @if (! empty($filters) && isset($filters[$report->class]) && ! empty($filterDataValues))
        <nav class="navbar navbar-default">
            <div class="container-fluid">
                <div class="navbar-header clearfix">
                    <a class="navbar-brand" href="{{ route('admin.reports.clear', $report) }}" onclick="return confirm('Are you sure you want to clear your filters?')">
                        Filters
                    </a>
                    <p class="navbar-text navbar-left">
                        @foreach ($filterFields as $filter)
                            @if (isset($filter['field']))
                                @php $filterValues = $filterData[$filter['field']] ?? []; @endphp
                                @if (isset($filterValues['value']) && ! empty($filterValues['value']))
                                    <strong class="label label-success" style="padding: 4px 8px; font-size: 13px; border-radius: 50px; margin-right: 4px">{{ $filter['label'] ?? $filterValues['field'] }}: {{ $filterValues['value'] }}</strong>
                                @endif
                            @endif
                        @endforeach
                    </p>
                </div>
                <div class="navbar-text pull-right">
                    <a href="{{ route('admin.reports.clear', $report) }}" class="navbar-link">
                        <span style="margin-right: 10px;">Clear</span>
                        <span class="close">&times;</span>
                    </a>
                </div>
            </div>
        </nav>
    @endif

    <div class="row">
        <div class="col-sm-12">
            <div class="box box-primary">
                <div class="box-body">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>

    <div id="report-filter-modal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Filters</h4>
                </div>
                <div class="modal-body">
                    @if (! empty($filters))
                        <form action="{{ route('admin.reports.show', $report) }}" method="POST" class="form-horizontal report-filter">
                            @foreach ($filterFields as $filter)
                                @if (isset($filter['view']))
                                    @include($filter['view'], compact('report', 'filter'))
                                @endif
                            @endforeach
                            <div class="form-group">
                                <label class="control-label col-sm-3">&nbsp;</label>
                                <div class="col-sm-9">
                                    @csrf
                                    <button class="btn btn-primary">Apply</button>
                                </div>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}

    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            var buttons = [];
            buttons.push({
                text: '<span class="fa-solid fa-filter"></span> <span>Filter</span>',
                action: function (e) {
                    e.preventDefault();
                    $('#report-filter-modal').modal();
                },
                enabled: {{ empty($filters) || empty($filters[$report->class]) ? 'false' : 'true' }}
            });
            $dataTable.customButtons({
                buttons: buttons
            });
        });
    </script>
@endsection
