<section class="chart-metric chart-gauge {{ $size }}">
    <div id="{{ $element }}" class="metric-panel metric-style-{{ $color ?? 'default' }}">
        <div class="metric-body">
            <p class="metric-label">{{ $label }}</p>
            <div class="metric-graph-full" style="position: relative; min-height: 335px; display: flex; align-items: center; justify-content: center">
                @if (empty($data->toArray()))
                    <div class="text-muted text-center">
                        <span class="fa-solid fa-exclamation-triangle fa-3x text-gray" style="margin-bottom: 20px"></span>
                        <h3 class="metric-label">No data available</h3>
                        <p class="metric-change">Try choosing a different date range</p>
                    </div>
                @else
                    <div class="chart" id="{{ $element }}-graph"></div>
                @endif
            </div>
        </div>
        @if (! empty($help))
            <button type="button" class="metric-help" data-toggle="tooltip" data-placement="left" title="{{ $help ?? '' }}" data-trigger="hover">
                <span class="fa-solid fa-question metric-icon-bg text-gray"></span>
            </button>
        @endif
    </div>
</section>
@push('css')
    <style type="text/css">
        /* Graph Container */
        #{{ $element }} table {
            margin-left: auto !important;
            margin-right: auto !important;
        }

        /* Outer-ring */
        #{{ $element }} circle:nth-child(1) {
            stroke-width: 0;
            stroke: #fff;
            fill: #fff;
        }

        /* Main background */
        #{{ $element }} circle:nth-child(2) {
            fill: #fff;
            stroke: #fff;
            stroke-width: 0;
        }

        /* Circle of the pointer */
        #{{ $element }} circle:nth-child(3) {
            fill: #333;
            stroke: #fff;
            stroke-width: 3;
        }

        /* Main text of the gauge */
        #{{ $element }} text {
            /*fill: yellow;*/
            /*font-family: 'Comfortaa';*/
        }

        /* Current value text */
        #{{ $element }} text:nth-child(1) {
            fill: #000;
            font-size: 33;
            /*font-weight: 700;*/
            /*font-family: 'Orbitron';*/
        }

        /* Ticks */
        #{{ $element }} path {
            stroke: #000;
            stroke-opacity: 0;
        }

        /* Pointer */
        #{{ $element }} path:nth-child(2) {
            fill: #333;
            stroke: #666;
            stroke-width: 1;
            fill-opacity: 1;
        }

        /* Good area */
        #{{ $element }} path:nth-child(3) {
            /*fill: #008450;*/
            fill: {{ $colors[0] ?? '#c82d2d' }};
        }

        /* Warning area */
        #{{ $element }} path:nth-child(4) {
            /*fill: #efb700;*/
            fill: {{ $colors[1] ?? '#fdbc18' }};
        }

        /* Danger area */
        #{{ $element }} path:nth-child(5) {
            /*fill: #b81d13;*/
            fill: {{ $colors[2] ?? '#53a629' }};
        }
    </style>
@endpush

@push('js')
    <script type="application/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    @if (! empty($data->toArray()))
        <script type="text/javascript">
            google.charts.load('current', {'packages':['gauge']});
            google.charts.setOnLoadCallback(drawChart);

            function drawChart() {
                let data = google.visualization.arrayToDataTable([
                    ['Label', 'Value'],
                    ['', {v: {{ $data->map->percentage->values()->first() ?? 0 }}, f: "{{ $data->map->percentage->values()->first() ?? 0 }}%"}]
                ]);

                let options = {
                    width: 320, height: 310,
                    {!! $slices !!},
                    minorTicks: 5,
                    majorTicks:['0%', '100%'],
                    vAxis: {
                        maxValue: 100,
                        format: '#%'
                    }
                };

                let {{ \Illuminate\Support\Str::camel($element . "_chart") }} = new google.visualization.Gauge(document.querySelector("#{{ $element }}-graph"));
                {{ \Illuminate\Support\Str::camel($element . "_chart") }}.draw(data, options);

                function resizeHandler () {
                    {{ \Illuminate\Support\Str::camel($element . "_chart") }}.draw(data, options);
                }
                if (window.addEventListener) {
                    window.addEventListener('resize', resizeHandler, false);
                }
                else if (window.attachEvent) {
                    window.attachEvent('onresize', resizeHandler);
                }
            }
        </script>
    @endif
@endpush
