<?php

namespace Ignite\Core\Contracts;

interface MetricInterface
{
    /**
     * The name of the metric.
     *
     * @return string
     */
    public function name();

    /**
     * The count of the metric.
     *
     * @return mixed
     */
    public function count();

    /**
     * The total value/amount of the metric.
     *
     * @return string
     */
    public function total();

    /**
     * The percentage of the given total.
     *
     * @param float|int $total
     * @return float|int
     */
    public function percentage($total);

    /**
     * Get the configured color name for the metric.
     *
     * @param  string $default
     * @return string
     */
    public function color($default = '#dddddd');

    /**
     * Get the configured class name for the metric.
     *
     * @param  string $default
     * @return string
     */
    public function style($default = 'default');
}
