<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Filters\QueryPermissionFilters;
use Illuminate\Database\Query\Builder;

class TrashedTable extends ParticipantTable
{
    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [
        'checkbox', 'user_id',
    ];

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns(): array
    {
        $columns = array_merge(
            ['checkbox' => $this->checkboxColumn()],
            parent::columns()
        );

        unset($columns['action']);

        return $columns;
    }

    /**
     * The trashed users query.
     *
     * @return Builder
     */
    public function query(): Builder
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('action', 'checkbox')
            ->keys()
            ->toArray();

        $query = $this->getConnection()
            ->table('core_participant AS participant')
            ->select($columns)
            ->leftJoin('core_user AS user', 'user.user_id', '=', 'participant.user_id')
            ->whereNotNull('participant.deleted_at');

        return QueryPermissionFilters::for('core.user.participant.browse')
            ->apply($query, 'participant');
    }

    /**
     * Add the checkbox field to the column map.
     *
     * @return array
     */
    protected function getColumnFormattingMap(): array
    {
        return array_merge(parent::getColumnFormattingMap(), [$this->formatter, 'checkbox']);
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters(): array
    {
        return parent::getBuilderParameters([
            "order" => [2, 'asc'], // Last Login
        ], $this->getCheckboxColumnParameters());
    }
}
