<?php

namespace Ignite\Core\Models\Grid;

use Illuminate\Support\HtmlString;
use Ignite\Core\Entities\Report;

class ReportFormatter extends Formatter
{
    /**
     * Format the actions column.
     *
     * @param  Report $report
     *
     * @return HtmlString
     */
    public function actions(Report $report)
    {
        ray('actions');
        if (auth()->user()->cannot('core.report.view')) {
            return $this->html('<span class="text-danger">Unauthorized</span>');
        }
        if ($report->isInactive()) {
            return $this->html('<span class="text-danger">Deactivated</span>');
        }

        if ($report->isUnpublished() || $report->isSensitive()) {
            return $this->html(sprintf(
                '<span class="text-danger">%s</span>',
                'Please contact I.T. to temporarily publish the report.'
            ));
        }

        ray(sprintf(
            '<a class="btn btn-sm btn-default" href="%s">Show</a>',
            route('admin.reports.show', ['id' => $report->getKey()])
        ));
        return $this->html(sprintf(
            '<a class="btn btn-sm btn-default" href="%s">Show</a>',
            route('admin.reports.show', ['id' => $report->getKey()])
        ));
    }

    /**
     * Format the status column.
     *
     * @param  Report $report
     *
     * @return HtmlString
     */
    public function statusLabel(Report $report)
    {
        ray('statusLabel');
        return $this->html(
            sprintf(
                '<span class="fa fa-circle %s"></span> %s',
                $report->isActive() ? 'text-green' : 'text-red',
                ucfirst($report->status)
            )
        );
    }

    /**
     * Format the sensitive column.
     *
     * @param  Report $report
     *
     * @return string
     */
    public function sensitive(Report $report)
    {
        ray('sensitive', $report->isSensitive());
        return $this->html(
            sprintf(
                '<span class="fa %s"></span> <span class="%s">%s</span>',
                $report->isSensitive() ? 'fa-exclamation text-red' : 'fa-check text-green',
                $report->isSensitive() ? 'text-red' : 'text-green',
                $report->isSensitive() ? 'Yes' : 'No'
            )
        );
    }

    /**
     * Format the published at column.
     *
     * @param  Report $report
     *
     * @return HtmlString
     */
    public function publishedAt(Report $report)
    {
        ray('publishedAt');
        return $this->formatDate($report, 'published_at');
    }

    /**
     * Format the published at column.
     *
     * @param  Report $report
     *
     * @return HtmlString
     */
    public function unpublishedAt(Report $report)
    {
        ray('unpublishedAt');
        return $this->formatDate($report, 'unpublished_at');
    }
}
