<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Group;
use Illuminate\Support\HtmlString;

class PermissionFormatter extends Formatter
{
    /**
     * Custom column for checkboxes.
     *
     * @param Group $model
     * @return HtmlString
     */
    public function checkbox($model): HtmlString
    {
        return $this->formatCheckbox($model->id);
    }
    /**
     * Custom column for actions.
     *
     * @param  Group $model
     * @return HtmlString
     */
    public function actions($model): HtmlString
    {
        $actions = [];

        if (auth()->user()->can('core.security.permissions.update')) {
            $actions[] = [
                'link' => route('admin.security.permissions.edit', $model->id),
                'label' => 'Edit',
                'icon' => 'pencil'
            ];
        }

        if (auth()->user()->can('core.security.permissions.delete') && $model->isUserDefined()) {
            $actions[] = [
                'link' => route('admin.security.permissions.destroy', ['group' => $model->id]),
                'label' => 'Delete',
                'class' => 'delete-entry',
                'text' => 'text-danger',
                'type'  => 'default',
                'icon' => 'trash',
                'click' => "This action will permanently delete the permission. Are you sure you want to continue?",
            ];
        }

        return $this->html($this->buttons($actions));
    }

    /**
     * Format the column to determine whether the group is active or inactive.
     *
     * @param  object  $model
     * @return HtmlString
     */
    public function status(object $model): HtmlString
    {
        return $model->status === 1 ? 'Active' : 'Inactive';
    }

    /**
     * Format the column to determine whether the group is user-defined.
     *
     * @param  Group $model
     * @return HtmlString
     */
    public function isUserDefined($model): HtmlString
    {
        return $this->formatYesNo($model->is_user_defined);
    }
}
