<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Filters\QueryPermissionFilters;
use Illuminate\Database\Query\Builder;

class InternalTable extends ParticipantTable
{
    /**
     * The internal user query.
     *
     * @return Builder
     */
    public function query(): Builder
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('actions')
            ->keys()
            ->toArray();

        $query = $this->getConnection()
            ->table('core_participant AS participant')
            ->select($columns)
            ->leftJoin('core_user AS user', 'user.user_id', '=', 'participant.user_id')
            ->where('user.internal', '=', 1)
            ->where('user.status', '=', $this->status)
            ->whereNull('deleted_at');

        return QueryPermissionFilters::for('core.user.internal.browse')
            ->apply($query, 'participant');
    }
}
