<?php

namespace Ignite\Core\Models\Grid;

use Illuminate\Support\HtmlString;
use Ignite\Core\Entities\Import;

class ImportFormatter extends Formatter
{
    /**
     * Format the actions column.
     *
     * @param  Import $import
     * @return HtmlString
     */
    public function actions(Import $import)
    {
        ray('actions');
        $actions = [];

        if (auth()->user()->can('core.import.view')) {
            $actions[] = [
                'link' => route('admin.import.show', $import),
                'label' => 'View',
                'icon' => 'eye'
            ];
        }

        if (auth()->user()->can('core.import.delete') && $import->isPending()) {
            $actions[] = [
                'link' => route('admin.import.destroy', $import),
                'label' => 'Delete',
                'class' => 'delete-entry',
                'text' => 'text-danger',
                'type'  => 'default',
                'icon' => 'trash',
                'click' => "This action will permanently delete the import. Are you sure you want to continue?",
            ];
        }

        return $this->buttons($actions);
    }

    /**
     * The label for the status value.
     *
     * @param Import $import
     *
     * @return HtmlString|string
     */
    public function statusLabel(Import $import)
    {
        ray('statusLabel');
        return $import->getStatusLabel();
    }

    /**
     * The type of import.
     *
     * @param Import $import
     *
     * @return string
     */
    public function type(Import $import)
    {
        ray('type');
        return $import->getTypeLabel();
    }

    /**
     * The type of import.
     *
     * @param Import $import
     *
     * @return string
     */
    public function file(Import $import)
    {
        ray('file');
        if (auth()->user()->can('core.import.download') && ! empty($import->file)) {
            return $this->html(sprintf(
                '<a href="%s">%s</a>',
                route('admin.import.download', $import),
                $import->file
            ));
        }

        if (empty($import->file)) {
            return $this->html('<span class="label label-danger">Missing File</span>');
        }

        return $import->file;
    }

    /**
     * The user that created the import.
     *
     * @param Import $import
     *
     * @return string
     */
    public function createdBy(Import $import)
    {
        ray('createdBy');
        return $import->getCreatedBy();
    }

    /**
     * The user that ran the import.
     *
     * @param Import $import
     *
     * @return string
     */
    public function runBy(Import $import)
    {
        ray('runBy');
        return $import->getRunBy();
    }

    /**
     * Format the published at column.
     *
     * @param  Import $import
     * @return HtmlString
     */
    public function runAt(Import $import)
    {
        ray('runAt');
        return $this->formatDate($import, 'run_at');
    }
}
