<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Group;
use Illuminate\Database\DatabaseManager;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\DataTables;

class GroupTable extends EloquentTable
{
    /**
     * @var GroupFormatter
     */
    protected $formatter;

    /**
     * GroupTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param GroupFormatter $formatter
     * @param array $params
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        GroupFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns(): array
    {
        return [
            'checkbox' => [
                'defaultContent' => '',
                'title' => '',
                'data' => 'checkbox',
                'name' => 'checkbox',
                'orderable' => false,
                'searchable' => false,
                'exportable' => false,
                'printable' => false,
                'width' => '10px',
            ],
            'action' => [
                'name' => 'actions',
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '80px',
                'class' => 'actions'
            ],
            'id' => [
                'title' => 'Group ID',
                'name' => 'id',
                'orderable' => true,
                'exportable' => true,
            ],
            'key' => [
                'title' => 'Key',
                'name' => 'key',
                'orderable' => true,
                'exportable' => true,
            ],
            'name' => [
                'title' => 'Name',
                'name' => 'name',
                'orderable' => true,
                'exportable' => true,
            ],
            'description' => [
                'title' => 'Description',
                'name' => 'description',
                'orderable' => true,
                'exportable' => true,
            ],
            'level' => [
                'title' => 'Level',
                'name' => 'level',
                'orderable' => true,
                'exportable' => true,
            ],
            'status' => [
                'title' => 'Status',
                'name' => 'status',
                'orderable' => true,
                'exportable' => true,
            ],
            'is_user_defined' => [
                'title' => 'User Defined',
                'name' => 'is_user_defined',
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The report query.
     *
     * @return Builder
     */
    public function query(): Builder
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except(['checkbox', 'actions'])
            ->keys()
            ->toArray();

        return Group::query();
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap(): array
    {
        return [
            'checkbox' => [$this->formatter, 'checkbox'],
            'action' => [$this->formatter, 'actions'],
            'status' => [$this->formatter, 'status'],
            'is_user_defined' => [$this->formatter, 'isUserDefined'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters(): array
    {
        return parent::getBuilderParameters([
            'order' => [[6, 'asc']], // Level
        ], $this->getCheckboxColumnParameters());
    }
}
