<?php

namespace Ignite\Core\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateBlockRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|max:255',
            'code' => 'required|regex:/([a-z0-9\-\/])/',
            'locale' => 'size:5|regex:/([a-z]){2}_([A-Z]){2}/',
            'content' => 'required',
            'status' => 'required|in:active,inactive',
            'published_at' => 'required|date_format:Y-m-d H:i:s',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'code.unique' => sprintf('The block code `%s` has already been used.', $this->code),
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('core.cms.blocks.create');
    }
}
