<?php

namespace Ignite\Core\Http\Controllers\Admin;

use Ignite\Core\Contracts\Repositories\ParticipantRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Ignite\Core\Models\Grid\InternalTable;
use Ignite\Core\Http\Controllers\Controller;
use Illuminate\View\View;

class InternalController extends Controller
{
    /**
     * @var ParticipantRepository
     */
    private ParticipantRepository $participantRepository;

    /**
     * TrashedController constructor.
     *
     * @param ParticipantRepository $participantRepository
     */
    public function __construct(ParticipantRepository $participantRepository)
    {
        $this->participantRepository = $participantRepository;
    }

    /**
     * The internal participants table.
     *
     * @param  InternalTable $table
     * @param  Request $request
     * @param  string $status
     * @return JsonResponse|View
     */
    public function index(InternalTable $table, Request $request, $status = 'active'): JsonResponse|View
    {
        $status = $request->query('status', $status);
        $statuses = $this->participantRepository->getStatuses();
        $statusLookup = array_flip($statuses);

        if (! array_key_exists($status, $statusLookup)) {
            $status = 'active';
        }

        $current = $status;

        $table->with('status', $statusLookup[$status]);

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Core::admin.participants.internal.index', compact(
            'statuses',
            'current'
        ));
    }
}
