<?php

namespace Ignite\Core\Contracts\Files;

use Ignite\Core\Files\File;
use Ignite\Core\Files\TemporaryFile;

interface FileGenerator
{
    /**
     * Generate this file.
     * It will be saved to a temporary location if no destination has been set.
     *
     * @return File|TemporaryFile The generated file.
     */
    public function generate();

    /**
     * Set where to save the generated file.
     *
     * @param File $file
     * @return static
     */
    public function destination(File $file): FileGenerator;

    /**
     * Add an encryption file processor to the file processor chain.
     *
     * @param FileEncrypter|string|null $fileEncrypter
     * @return static
     */
    public function addEncryption($fileEncrypter = null): FileGenerator;

    /**
     * Add a file processor to the file processor chain.
     *
     * @param FileProcessor|\Closure $fileProcessor
     * @return static
     */
    public function addProcessor($fileProcessor): FileGenerator;
}
