@extends('Core::layouts.master')

@section('body_class', 'sidebar-mini skin-black')

@section('body')
    <div class="wrapper">
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <ul class="navbar-nav">
                @include('Core::layouts.partials.nav-toggle')
                @include('Core::layouts.partials.nav-website')
            </ul>
            <ul class="navbar-nav ml-auto">
                @include('Core::layouts.partials.nav-user')
                <li class="nav-item">
                    <a href="#" data-widget="control-sidebar" data-slide="true"><i class="fa fa-cog"></i></a>
                </li>
            </ul>
        </nav>

        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            @include('Core::layouts.partials.logo')
            <div class="sidebar">
                {{ $menu }}
            </div>
        </aside>

        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        @yield('content_header')
                    </div>
                </div>
            </div>
            <section class="content">
                @yield('content')
            </section>
        </div>
        @include('Core::layouts.partials.footer')

        @include('Core::partials.sidebar')
    </div>
@stop
