@extends('Core::layouts.main')

@section('meta_title', $title = 'Content Management')

@section('heading')
    <div class="col-sm-6">
        <h1 class="m-0 text-dark">
            @yield('page_heading')
            <small><a href="{{ route('admin.pages.index') }}">{{ $title }}</a></small>
        </h1>
    </div>
@endsection

@section('breadcrumb')
    @parent
    <li class="breadcrumb-item"><a href="{{ route('admin.pages.index') }}">CMS</a></li>
    <li class="breadcrumb-item active">@yield('page_breadcrumb')</li>
@endsection

@section('page_content')
    <div class="row">
        <div class="col-12">
            <div class="card card-primary card-outline card-outline-tabs">
                <div class="card-header p-0 border-bottom-0">
                    <ul class="nav nav-tabs" id="custom-tabs-tab" role="tablist">
                        @can('core.cms.pages.browse')
                            <li class="nav-item">
                                <a class="nav-link {{ request()->is('admin/cms/pages*') ? 'active' : '' }}" href="{{ route('admin.pages.index') }}" data-toggle="pill" role="tab" id="custom-tabs-pages-tab" aria-controls="custom-tabs-pages" aria-selected="{{ request()->is('admin/cms/pages*') ? 'true' : 'false' }}">Pages</a>
                            </li>
                        @endcan
                        @can('core.cms.blocks.browse')
                            <li class="nav-item">
                                <a class="nav-link {{ request()->is('admin/cms/blocks*') ? 'active' : '' }}" href="{{ route('admin.blocks.index') }}" data-toggle="pill" role="tab" id="custom-tabs-blocks-tab" aria-controls="custom-tabs-blocks" aria-selected="{{ request()->is('admin/cms/blocks*') ? 'true' : 'false' }}">Blocks</a>
                            </li>
                        @endcan
                        @can('core.cms.media.browse')
                            <li class="nav-item">
                                <a class="nav-link {{ request()->is('admin/cms/media*') ? 'active' : '' }}" href="{{ route('admin.media.index') }}" data-toggle="pill" role="tab" id="custom-tabs-media-tab" aria-controls="custom-tabs-media" aria-selected="{{ request()->is('admin/cms/media*') ? 'true' : 'false' }}">Media</a>
                            </li>
                        @endcan
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content @yield('tab_content_class')" id="custom-tabs-tabContent">
                        @yield('tab_content')
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
