@extends('Core::layouts.main')

@section('meta_title', 'Dashboard')

@section('heading')
    <div class="col-sm-6">
        <h1 class="m-0 text-dark">Dashboard</h1>
    </div>
    <div class="col-sm-6">
        @unless (empty($dashboards))
            <div class="input-group pull-left" style="max-width: 400px; margin-left: 25px;">
                <form name="views" method="GET" action="{{ route('admin.dashboard.index') }}">
                    <select title="Choose Dashboard View" onchange="forms.views.submit()" name="dashboard" id="dashboard" class="select2 pull-left" style="min-width: 200px;">
                        @foreach ($dashboards as $value)
                            <option {{ $value === $dashboard ? 'selected' : '' }} value="{{ $value }}">{{ $value }} Dashboard</option>
                        @endforeach
                    </select>
                </form>
            </div>
        @endunless
        @if(view()->exists("admin.dashboard.date-range-picker"))
            @include('admin.dashboard.date-range-picker')
        @else
            @include('Core::admin.dashboard.date-range-picker')
        @endif
    </div>
@endsection

@section('page_content')
    <div class="container-fluid dashboard">
        @php $chartSection = null; @endphp
        @forelse ($charts as $chart)
            @if($chart->group != $chartSection)
                <div class="col-xs-12"><h3 class="col-12">{{ $chart->group }}</h3></div>
                <div class="row">
            @endif
            @if(view()->exists("admin.dashboard.components.{$chart->getType()}"))
                @component("admin.dashboard.components.{$chart->getType()}", $chart->toArray())@endcomponent
            @else
                @component("Core::admin.dashboard.components.{$chart->getType()}", $chart->toArray())@endcomponent
            @endif
            @php $chartSection = $chart->group; @endphp
        @empty
            <div class="col-xs-12"><p>No charts available.</p></div>
        @endforelse
                </div>
    </div>
@stop

@section('js')
    @parent
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery.matchHeight/0.7.2/jquery.matchHeight-min.js"></script>
    <script type="text/javascript">
        jQuery(function($) {
            var types = ['.chart-stat', '.chart-correlated-stat', '.chart-donut', '.chart-gauge', '.chart-line', '.chart-table'];
            for (var i = 0; i <= types.length; i++) {
                var type = types[i];
                var elements = $(type);
                var tallest = $(type).first();
                var smallest = $(type).first();
                for (var j = 0; j <= elements.length; j++) {
                    var next = $(elements[j]);
                    if (tallest.height() <= next.height()) {
                        tallest = next;
                    } else {
                        smallest = next;
                    }
                }

                $(type).matchHeight({
                    byRow: true,
                    property: 'min-height',
                    target: tallest,
                    remove: true
                });
            }
        });
    </script>
@endsection
