<form class="form-inline float-sm-right hidden-xs hidden-sm" id="date-range-picker">
    <!-- Range Start -->
    <div style="min-width: 100px" class="form-group {{ $selectedType === 'range' ? '' : 'hidden' }}">
        <input type="text" id="date-range-current-from" name="date-range-current-from" class="form-control" placeholder="Start Date" value="{{ request()->query('current-start', $selectedCurrent->format('Y-m-d')) }}">
    </div>

    <!-- Range End -->
    <div style="min-width: 100px" class="form-group {{ $selectedType === 'range' ? '' : 'hidden' }}">
        <input type="text" id="date-range-current-to" name="date-range-current-to" class="form-control" placeholder="End Date" value="{{ request()->query('current-end', today()->format('Y-m-d')) }}">
    </div>

    <!-- Current Month -->
    <div style="min-width: 100px" class="form-group {{ $selectedType === 'month' ? '' : 'hidden' }}">
        <select style="min-width: 100px" id="date-range-current-month" name="current_month" class="form-control select2">
            @foreach ($months as $month => $name)
                <option {{ $month === $selectedCurrent->month ? 'selected' : '' }} value="{{ $month }}">{{ $name }}</option>
            @endforeach
        </select>
    </div>

    <!-- Current Quarter -->
    <div class="form-group {{ $selectedType === 'quarter' ? '' : 'hidden' }}">
        <select id="date-range-current-quarter" name="current_quarter" class="form-control select2">
            @foreach ($quarters as $quarter)
                <option {{ $quarter === $selectedCurrent->quarter ? 'selected' : '' }} value="{{ $quarter }}">{{ $quarter }}</option>
            @endforeach
        </select>
    </div>

    <!-- Current Year -->
    <div class="form-group {{ $selectedType !== 'range' ? '' : 'hidden' }}">
        <select id="date-range-current-year" name="current_year" class="form-control select2">
            @foreach ($years as $year)
                <option {{ $year === $selectedCurrent->year ? 'selected' : '' }} value="{{ $year }}">{{ $year }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group {{ $selectedType !== 'range' ? '' : 'hidden' }}"><span id="date-range-vs"> vs </span></div>

    <!-- Previous Month -->
    <div style="min-width: 100px" class="form-group {{ $selectedType === 'month' ? '' : 'hidden' }}">
        <select id="date-range-previous-month" name="previous_month" class="form-control select2">
            @foreach ($months as $month => $name)
                <option {{ $month === $selectedPrevious->month ? 'selected' : '' }} value="{{ $month }}">{{ $name }}</option>
            @endforeach
        </select>
    </div>

    <!-- Previous Quarter -->
    <div class="form-group {{ $selectedType === 'quarter' ? '' : 'hidden' }}">
        <select id="date-range-previous-quarter" name="current_previous" class="form-control select2">
            @foreach ($quarters as $quarter)
                <option {{ $quarter === $selectedPrevious->quarter ? 'selected' : '' }} value="{{ $quarter }}">{{ $quarter }}</option>
            @endforeach
        </select>
    </div>

    <!-- Previous Year -->
    <div class="form-group {{ $selectedType !== 'range' ? '' : 'hidden' }}">
        <select id="date-range-previous-year" name="previous_year" class="form-control select2">
            @foreach ($years as $year)
                <option {{ $year === $selectedPrevious->year ? 'selected' : '' }} value="{{ $year }}">{{ $year }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group">
        <button type="submit" class="btn btn-default">Change</button>
    </div>
</form>

@push('css')
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
@endpush
@push('js')
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script>
        jQuery(function ($) {
            let pickerForm = $('#date-range-picker');
            let pickerType = $('#date-range-type');

            let dateFormat = "yy-mm-dd",
                from = $( "#date-range-current-from" )
                    .datepicker({
                        defaultDate: "-1w",
                        changeMonth: true,
                        numberOfMonths: 1,
                        dateFormat: dateFormat
                    })
                    .on( "change", function() {
                        to.datepicker( "option", "minDate", getDate( this ) );
                    }),
                to = $( "#date-range-current-to" ).datepicker({
                    defaultDate: "+1w",
                    changeMonth: true,
                    numberOfMonths: 2,
                    dateFormat: dateFormat
                })
                    .on( "change", function() {
                        from.datepicker( "option", "maxDate", getDate( this ) );
                    });

            // from.datepicker("setDate", "2005-01-26");
            // to.datepicker("setDate", new Date());

            function getDate( element ) {
                let date;
                try {
                    date = $.datepicker.parseDate( dateFormat, element.value );
                } catch( error ) {
                    date = null;
                }

                return date;
            }

            pickerType.on('change', function () {
                window.location.href = '/admin?type=' + $(this).val();
            });

            pickerForm.on('submit', function (e) {
                e.preventDefault();

                // get the comparison type
                var selectedType = $(this).find('#date-range-type').val() || 'range';

                // get the current start date value
                var currentRangeStart = $(this).find('#date-range-current-from').val();
                // get the current end date value
                var currentRangeEnd = $(this).find('#date-range-current-to').val();

                // get the current month value
                var currentMonth = $(this).find('#date-range-current-month').val();
                // get the current year value
                var currentYear = $(this).find('#date-range-current-year').val();

                // get the previous month value
                var previousMonth = $(this).find('#date-range-previous-month').val();
                // get the previous year value
                var previousYear = $(this).find('#date-range-previous-year').val();

                // redirect with the correct values
                var currentStart, currentEnd, previousStart, previousEnd;

                if (selectedType === 'range') {
                    currentStart = moment(currentRangeStart).startOf('day');
                    currentEnd = moment(currentRangeEnd).endOf('day');
                }

                if (selectedType === 'month') {
                    currentStart = moment([currentYear, currentMonth -1]).startOf('month').startOf('day');
                    currentEnd = currentStart.clone().endOf('month').endOf('day');
                }

                if (selectedType === 'quarter') {
                    currentStart = moment([currentYear, currentMonth -1]).startOf('quarter').startOf('day');
                    currentEnd = currentStart.clone().endOf('quarter').endOf('day');
                }

                if (selectedType === 'year') {
                    currentStart = moment([currentYear, currentMonth -1]).startOf('year').startOf('day');
                    currentEnd = currentStart.clone().endOf('year').endOf('day');
                }

                if (selectedType === 'month') {
                    previousStart = moment([previousYear, previousMonth - 1]).startOf('month').startOf('day');
                    previousEnd = previousStart.clone().endOf('month').endOf('day');
                }

                if (selectedType === 'quarter') {
                    previousStart = moment([previousYear, previousMonth - 1]).startOf('quarter').startOf('day');
                    previousEnd = previousStart.clone().endOf('quarter').endOf('day');
                }

                if (selectedType === 'year') {
                    previousStart = moment([previousYear, previousMonth - 1]).startOf('year').startOf('day');
                    previousEnd = previousStart.clone().endOf('year').endOf('day');
                }

                window.location.href = '/admin' + '?type=' + selectedType + '&current-start=' + currentStart.format('YYYY-MM-DD') + '&current-end=' + currentEnd.format('YYYY-MM-DD');
            });
        });
    </script>
@endpush
