@extends('Core::layouts.main')

@section('meta_title', $title = 'Participant Management')

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.participant.index') }}">{{ $title }}</a></small>
    </h1>
@endsection

@section('breadcrumb')
    @parent
    <li><a href="{{ route('admin.participant.index') }}">{{ $title }}</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('page_content')
    <div class="nav-tabs-custom">
        @yield('tab_menu')
        <div class="tab-content">
            @yield('tab_content')
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script>
        jQuery(document).ready(function($) {
            $('.datepicker').each(function () {
                var options = $.extend({
                    dateFormat: "mm/dd/yy"
                }, $(this).data("datepicker"));
                $(this).datepicker(options).on('show.bs.modal', function(event) {
                    event.stopPropagation();
                });
            });

            $('.datetimepicker').datetimepicker({
                format: 'MM/DD/YYYY HH:mm:ss',
                icons: {
                    time: "fa-solid fa-clock",
                    date: "fa-solid fa-calendar",
                    up: "fa-solid fa-arrow-up",
                    down: "fa-solid fa-arrow-down",
                    previous: 'fa-solid fa-chevron-left',
                    next: 'fa-solid fa-chevron-right',
                    today: 'fa-solid fa-calendar-times',
                    clear: 'fa-solid fa-trash',
                    close: 'fa-solid fa-remove'
                }
            });
        });
    </script>
@endsection
