<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Ignite\Core\Entities\User;

$factory->define(User::class, function (Faker\Generator $faker) {
    static $password;

    $email = $faker->unique()->safeEmail;

    return [
        'email' => $email,
        'password' => $password ?: $password = bcrypt('secret'),
        "username" => $email,
        "first" => $faker->firstName,
        "last" => $faker->lastName,
        "password_salt" => "",
        "status" => 1,
        "internal" => 1,
        'remember_token' => str_random(10),
    ];
});

$factory->state(User::class, 'external', ['internal' => 0]);
