<?php

namespace Ignite\Core\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class TransactionResource.
 *
 * @property int $id
 * @property string|null $identifier
 * @property int|null $related_id
 * @property string|null $related_type
 * @property string|null $type
 * @property string|null $description
 * @property float|null $value
 * @property string|null $notes
 * @property string|null $tax_date
 * @property string|null $related_name
 * @property string|null $transaction_date
 * @property string|null $hash
 * @property \Illuminate\Support\Carbon|null $deleted_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Ignite\Core\Entities\Participant $participant
 * @method static Builder|Transaction byCurrentUser()
 * @method static Builder|TransactionResource byIds($ids)
 * @method static Builder|Transaction byUser($user)
 * @method static Builder|TransactionResource newModelQuery()
 * @method static Builder|TransactionResource newQuery()
 * @method static \Illuminate\Database\Query\Builder|TransactionResource onlyTrashed()
 * @method static Builder|TransactionResource query()
 * @method static Builder|TransactionResource whereCreatedAt($value)
 * @method static Builder|TransactionResource whereDeletedAt($value)
 * @method static Builder|TransactionResource whereDescription($value)
 * @method static Builder|Base whereHasPermission(string $permission, ?\Ignite\Core\Entities\User $user = null)
 * @method static Builder|TransactionResource whereHash($value)
 * @method static Builder|TransactionResource whereId($value)
 * @method static Builder|TransactionResource whereIdentifier($value)
 * @method static Builder|TransactionResource whereNotes($value)
 * @method static Builder|TransactionResource whereRelatedId($value)
 * @method static Builder|TransactionResource whereRelatedName($value)
 * @method static Builder|TransactionResource whereRelatedType($value)
 * @method static Builder|TransactionResource whereTaxDate($value)
 * @method static Builder|TransactionResource whereTransactionDate($value)
 * @method static Builder|TransactionResource whereType($value)
 * @method static Builder|TransactionResource whereUpdatedAt($value)
 * @method static Builder|TransactionResource whereValue($value)
 * @method static \Illuminate\Database\Query\Builder|TransactionResource withTrashed()
 * @method static \Illuminate\Database\Query\Builder|TransactionResource withoutTrashed()
 * @mixin \Eloquent
 */
class TransactionResource extends Transaction
{
    use SoftDeletes;

    /**
     * The name of the table.
     *
     * @var string
     */
    protected $table = 'core_transaction_resource';

    /**
     * The guarded attributes.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Query for multiple IDs.
     *
     * @param  Builder      $query
     * @param  array|string $ids
     * @return Builder
     */
    public function scopeByIds(Builder $query, $ids): Builder
    {
        if (is_string($ids)) {
            $ids = preg_split('/\s?,\s?/', $ids);
        }

        $query->whereIn('id', $ids);

        return $query;
    }
}
