<?php

namespace Ignite\Core\Services\Monolog;

use Illuminate\Support\Facades\Mail;
use Monolog\Handler\MailHandler;

/**
 * Emails the error log messages. Add to your config/logging.php like:
 *     'mail' => [
 *         'driver' => 'monolog',
 *         'level' => 'error',
 *         'handler' => \Ignite\Core\Services\Monolog\MailerHandler::class,
 *     ],
 */
class MailerHandler extends MailHandler
{
    /**
     * @param  string $content
     * @param  array  $records
     */
    protected function send(string $content, array $records): void
    {
        $subject = $records[0]['message'] ?? $content;
        Mail::raw(
            $content,
            function ($message) use ($subject) {
                // $message->from(config('mail.from.address'));
                $message->to(config('core.admin.email'));
                $message->subject('[ERROR] ' . $subject);
            }
        );
    }
}
