<?php

namespace Ignite\Core\Presenters;

use Ignite\Packages\Presenter\Presenter;

/**
 * Class Participant
 * @property \Ignite\Core\Entities\Participant $entity
 */
class Participant extends Presenter
{
    /**
     * The primary key of the row.
     *
     * @return int
     */
    public function getId()
    {
        return (int) $this->entity->getKey();
    }

    /**
     * The participant's full name.
     *
     * @return string
     */
    public function getFullName()
    {
        return $this->entity->fullName();
    }

    /**
     * The type of participant.
     *
     * @return string
     */
    public function getType()
    {
        return $this->entity->type;
    }

    /**
     * The total transactions for this participant.
     *
     * @return int
     */
    public function getTransactionCount()
    {
        return $this->entity->transactions()->count();
    }
}
