<?php

namespace Ignite\Core\Models\Seeds;

abstract class BaseSeeder
{
    /** @var string */
    protected $json = '';

    /** @var string */
    protected $filepath = null;

    /** @var JsonSeederParser */
    protected $parser;

    /**
     * CoreTableSeeder constructor.
     *
     * @param JsonSeederParser $parser
     */
    public function __construct(JsonSeederParser $parser)
    {
        $this->parser = $parser;
    }

    /**
     * The path to the json file.
     *
     * @return string
     */
    public function path()
    {
        if ($this->filepath) {
            return $this->filepath . "/$this->json}.json";
        } else {
            return database_path("data/{$this->json}.json");
        }
    }

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    abstract public function seed();
}
