<?php

namespace Ignite\Core\Models\Menu;

use Spatie\Menu\Menu;

class MenuExtended extends \Spatie\Menu\Laravel\Menu
{
    /**
     * Add a class to all items in the menu.
     *
     * @param string $class
     *
     * @return $this
     */
    public function addItemClass(string $class): Menu
    {
        $this->applyToAll(function (\Spatie\Menu\Link $link) use ($class) {
            $link->addClass($class);
        });

        return $this;
    }
}
