<?php

namespace Ignite\Core\Models\Import\Resolvers;

use Ignite\Core\Contracts\Imports\ImportResolver;
use Ignite\Core\Entities\User;

class UserResolver implements ImportResolver
{
    /**
     * @inheritdoc
     */
    public function resolve(User $user)
    {
        if (! $user->relationLoaded('participant')) {
            $user->load('participant');
        }

        $field = $user->getTransactionResourceIdentifier();

        if (! empty($user->getAttribute($field))) {
            return $user->getAttribute($field);
        }

        if (isset($user->participant) && ! empty($user->participant->getAttribute($field))) {
            return $user->participant->getAttribute($field);
        }

        return false;
    }
}
