<?php

namespace Ignite\Core\Http\ViewComposers;

use Illuminate\Support\HtmlString;
use Illuminate\View\View;
use Ignite\Core\Models\Menu\AdminMenu;

class AdminMenuComposer
{
    /**
     * @var AdminMenu
     */
    private $manager;

    public function __construct(AdminMenu $manager)
    {
        $this->manager = $manager;
    }

    /**
     * Compose the view.
     *
     * @param View $view
     */
    public function compose(View $view)
    {
        $this->manager->merge(
            $this->manager->hydrateItems(
                $this->getItems()
            )
        );

        $view->with('menu', new HtmlString($this->manager->render()));
    }

    /**
     * The items to seed the menu with for the core.
     *
     * @return \Illuminate\Support\Collection
     */
    private function getItems()
    {
        return collect([
            [
                'position' => 10,
                'url' => route('admin.dashboard.index'),
                'label' => 'Dashboard',
                'icon' => 'dashboard',
                'allow' => auth()->user()->can('core.dashboard.browse'),
            ],
            [
                'position' => 20,
                'url' => '/admin/cms',
                'label' => 'Content',
                'icon' => 'edit',
                'allow' => auth()->user()->can('core.cms.browse'),
                'children' => [
                    [
                        'position' => 1,
                        'url'  => route('admin.pages.index'),
                        'label' => 'Pages',
                        'icon' => 'file-text',
                        'allow' => auth()->user()->can('core.cms.pages.browse'),
                    ],
                    [
                        'position' => 2,
                        'url'  => route('admin.blocks.index'),
                        'label' => 'Blocks',
                        'icon' => 'cubes',
                        'allow' => auth()->user()->can('core.cms.blocks.browse'),
                    ],
                    [
                        'position' => 3,
                        'url'  => route('admin.media.index'),
                        'label' => 'Media',
                        'icon' => 'camera',
                        'allow' => auth()->user()->can('core.cms.media.browse'),
                    ]
                ]
            ],
            [
                'position' => 30,
                'url' => '/admin/participant',
                'label' => 'Users',
                'icon' => 'users',
                'allow' => auth()->user()->can('core.user.browse')
                    || auth()->user()->can('core.user.participant.browse'),
                'children' => [
                    [
                        'position' => 1,
                        'url' => route('admin.participant.index'),
                        'label' => 'Participants',
                        'icon' => 'user',
                        'allow' => auth()->user()->can('core.user.participant.browse'),
                    ],
                    [
                        'position' => 2,
                        'url' => route('admin.participant.internal'),
                        'label' => 'Internal',
                        'icon' => 'user-circle',
                        'allow' => auth()->user()->can('core.user.internal.browse'),
                    ],
                    [
                        'position' => 3,
                        'url' => route('admin.participant.trashed'),
                        'label' => 'Trashed',
                        'icon' => 'trash',
                        'allow' => auth()->user()->can('core.user.trashed.browse'),
                    ]
                ],
            ],
            [
                'position' => 90,
                'url' => '/admin/transactions',
                'label' => 'Transactions',
                'icon' => 'exchange',
                'allow' => auth()->user()->can('core.transactions.browse'),
                'children' => [
                    [
                        'position' => 1,
                        'url'  => '/admin/transactions', //route('admin.pages.index'),
                        'label' => 'All Transactions',
                        'icon' => 'refresh',
                        'allow' => auth()->user()->can('core.transactions.browse'),
                    ],
                    [
                        'position' => 2,
                        'url'  => '/admin/transactions/waiting', //route('admin.blocks.index'),
                        'label' => 'Waiting Transactions',
                        'icon' => 'clock',
                        'allow' => auth()->user()->can('core.transactions.waiting.browse'),
                    ]
                ]
            ],
            [
                'position' => 100,
                'url' => route('admin.import.index'),
                'label' => 'Imports',
                'icon' => 'cloud-upload',
                'allow' => auth()->user()->can('core.import.browse'),
            ],
            [
                'position' => 110,
                'url' => route('admin.reports.index'),
                'label' => 'Reports',
                'icon' => 'pie-chart',
                'allow' => auth()->user()->can('core.report.browse'),
            ],
            [
                'position' => 120,
                'url' => '/admin/security',
                'label' => 'Security',
                'icon' => 'lock',
                'allow' => auth()->user()->can('core.security.users.browse'),
                'children' => [
                    [
                        'position' => 1,
                        'url' => route('admin.security.users.index'),
                        'label' => 'Users',
                        'icon' => 'user-circle',
                        'allow' => auth()->user()->can('core.security.users.browse'),
                    ],
                    [
                        'position' => 2,
                        'url' => route('admin.security.groups.index'),
                        'label' => 'Groups',
                        'icon' => 'random',
                        'allow' => auth()->user()->can('core.security.groups.browse'),
                    ],
                    [
                        'position' => 3,
                        'url' => route('admin.security.permissions.index'),
                        'label' => 'Permissions',
                        'icon' => 'drivers-license',
                        'allow' => auth()->user()->can('core.security.permissions.browse'),
                    ]
                ]
            ]
        ]);
    }
}
