<?php

namespace Ignite\Core\Http\Controllers\Admin;

use Ignite\Core\Contracts\Repositories\ParticipantRepository;
use Illuminate\Http\Request;
use Ignite\Core\Http\Controllers\Controller;
use Ignite\Core\Models\Grid\ParticipantActivityTable;

class ParticipantActivityController extends Controller
{
    /**
     * @var ParticipantRepository
     */
    private $participantRepository;

    /**
     * ParticipantOrdersController constructor.
     *
     * @param ParticipantRepository $participantRepository
     */
    public function __construct(ParticipantRepository $participantRepository)
    {
        $this->participantRepository = $participantRepository;
    }

    /**
     * Show the Activity related to the provided participant.
     *
     * @param  bool|int $participantId
     * @param  ParticipantActivityTable $table
     * @param  Request $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\View\View
     * @throws \Ignite\Packages\Presenter\Exceptions\PresenterException
     */
    public function index($participantId, ParticipantActivityTable $table, Request $request)
    {
        $table->with('user_id', $participantId);
        $participant = $this->participantRepository->find($participantId)->present();

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Core::admin.participants.activity', compact(
            'participant',
            'participantId'
        ));
    }
}
