<?php

namespace Ignite\Core\Files\Encryption;

use Ignite\Core\Contracts\Files\FileEncrypter;

class FileEncryption
{
    /**
     * Fetch a file encryption provider.
     *
     * @param string|null $provider
     * @return FileEncrypter
     */
    public function encrypter(?string $provider = null): FileEncrypter
    {
        $provider = $provider ?? config('core.file_encryption.default');

        $this->assertProviderConfigExists($provider);

        $driver = config("core.file_encryption.providers.$provider.driver");
        return new $driver($provider);
    }

    /**
     * Does config settings exist for the given provider name?
     *
     * @param string $provider
     * @return bool
     */
    public function providerConfigExists(string $provider): bool
    {
        return config()->has('core.file_encryption.providers.'.$provider);
    }

    /**
     * Assert config settings exist for the given provider name.
     *
     * @param string $provider
     */
    public function assertProviderConfigExists(string $provider): void
    {
        if (! $this->providerConfigExists($provider)) {
            throw new \InvalidArgumentException("Driver [$provider] is not supported.");
        }
    }
}
