<?php

namespace Ignite\Core\Facades;

use Ignite\Core\Contracts\Files\FileEncrypter;
use Ignite\Core\Files\Encryption\FileEncryption as FileEncryptionConcrete;
use Illuminate\Support\Facades\Facade;

/**
 * @method static FileEncrypter encrypter(?string $provider = null)
 * @method static bool providerConfigExists(string $provider)
 * @method static void assertProviderConfigExists(string $provider)
 */
class FileEncryption extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return FileEncryptionConcrete::class;
    }
}
