<?php

namespace Ignite\Core\Events;

use Ignite\Core\Contracts\Entities\Participant;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Fluent;

class ParticipantUpdating
{
    use SerializesModels;

    /**
     * @var Fluent
     */
    public $data;

    /**
     * @var Participant
     */
    public $model;

    /**
     * Create a new event instance.
     *
     * @param Fluent $data
     * @param Participant $model
     */
    public function __construct(Fluent $data, Participant $model)
    {
        $this->data = $data;
        $this->model = $model;
    }
}
