<?php

namespace Ignite\Core\Contracts\Repositories;

use Ignite\Core\Entities\User;
use Ignite\Core\Entities\Transaction;

interface TransactionRepository
{
    /**
     * The allowed transaction types with matching keys and values.
     *
     * @return array
     */
    public function getAllowedTypes();

    /**
     * The current user's balance.
     *
     * @param  User|null $user
     * @return mixed
     */
    public function getBalance($user = null);

    /**
     * Find transactions by user.
     *
     * @param  int|User $user
     *
     * @return \Illuminate\Database\Eloquent\Collection|Transaction[]
     */
    public function findByUser($user);

    /**
     * Create a transaction.
     *
     * @param  array $data
     * @return Transaction
     */
    public function create(array $data);
}
