<?php

namespace Ignite\Core\Contracts\Repositories;

interface PageRepository
{
    /**
     * The default raw query builder object.
     *
     * @return Builder
     */
    public function findRaw();

    /**
     * Find all pages.
     *
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function findAll();

    /**
     * Find one page by primary key.
     *
     * @param  int $id
     * @return \Ignite\Core\Entities\Page
     */
    public function find($id);

    /**
     * Find one page by url code.
     *
     * @param  int $code
     * @return \Ignite\Core\Entities\Page
     */
    public function findByCode($code);

    /**
     * Find the homepage.
     *
     * @return \Ignite\Core\Entities\Page
     */
    public function findHomepage();

    /**
     * Find the pages for the navigation.
     *
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function findForNavigation();

    /**
     * Create a new page.
     *
     * @param  array $data
     * @return int
     */
    public function create(array $data);

    /**
     * Update a page using the id to locate it.
     *
     * @param  int $id
     * @param  array $data
     * @return int
     */
    public function update($id, array $data);

    /**
     * Reorder the position of pages in the front-end menu.
     *
     * @param  array $positions
     * @return \Illuminate\Support\Collection
     */
    public function reorder(array $positions);

    /**
     * Toggle a field on a resource.
     *
     * @param  int $id
     * @param  string $name
     * @param  string $value
     * @return bool
     */
    public function toggle($id, $name, $value);
}
