<?php

namespace Ignite\Core\Contracts\Repositories;

interface GroupRepository
{
    /**
     * The scoped Group query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * The groups accessible by the currently authenticated user.
     *
     * @return \Ignite\Core\Collections\GroupsCollection
     */
    public function getAccessibleGroups();

    /**
     * Find a group by primary key.
     *
     * @param  int $id
     * @return \Ignite\Core\Entities\Group
     */
    public function find($id);

    /**
     * Find a group by unique key.
     *
     * @param  string $key
     * @return \Ignite\Core\Entities\Group
     */
    public function findByKey($key);

    /**
     * Find all groups in the system.
     *
     * @return \Ignite\Core\Collections\GroupsCollection
     */
    public function findAll();

    /**
     * Create a new group and optionally provide permissions.
     *
     * @param  array $data
     * @param  array $permissions
     * @return \Ignite\Core\Entities\Group
     */
    public function create(array $data, array $permissions = []);

    /**
     * Update an existing group and optionally provide permissions.
     *
     * @param  int $id
     * @param  array $data
     * @param  array $permissions
     * @return \Ignite\Core\Entities\Group
     */
    public function update($id, array $data, array $permissions = []);

    /**
     * Delete the provide group by id.
     *
     * @param  int $id
     * @return \Ignite\Core\Entities\Group
     */
    public function delete($id);

    /**
     * Delete multiple groups in a batch request.
     *
     * @param  array $ids
     * @return array
     */
    public function deleteMany(array $ids);
}
