<?php

namespace Ignite\Core\Contracts\Repositories;

use Ignite\Core\Entities\Block;

interface BlockRepository
{
    /**
     * The default raw query builder object.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function findRaw();

    /**
     * Find all blocks.
     *
     * @param  int $limit
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function findAll($limit = null);

    /**
     * Find one block by primary key.
     *
     * @param  int $id
     * @return Block
     */
    public function find($id);

    /**
     * Find one block by primary key.
     *
     * @param  int $code
     * @return Block
     */
    public function findByCode($code);

    /**
     * Create a new block.
     *
     * @param  array $data
     * @return Block
     */
    public function create(array $data);

    /**
     * Update a block using the id to locate it.
     *
     * @param  int $id
     * @param  array $data
     * @return Block
     */
    public function update($id, array $data);

    /**
     * Delete a single block.
     *
     * @param  int $id
     * @return bool
     */
    public function delete($id);

    /**
     * Delete many blocks via multiple block IDs.
     *
     * @param  array $ids
     * @return int
     */
    public function deleteMany(array $ids);
}
